
#!/usr/bin/env python3
import subprocess, sys, os, datetime as dt
here = os.path.dirname(os.path.abspath(__file__))
root = os.path.dirname(here)
ts = dt.datetime.now(dt.timezone.utc).strftime("%Y-%m-%dT%H-%M-%SZ")
outdir = os.path.join(root, "J28_deflection_overlay", ts)
os.makedirs(outdir, exist_ok=True)
engine = os.path.join(root, "engine_j28_deflection_overlay.py")
manifest = os.path.join(root, "manifests", "manifest_j28_PASS.json")
cmd = [sys.executable, engine, "--manifest", manifest, "--outdir", outdir]
print("Running:", " ".join(cmd))
r = subprocess.run(cmd, text=True, capture_output=True)
print(r.stdout)
if r.stderr:
    print("STDERR:", r.stderr, file=sys.stderr)
print("Outputs at:", outdir)
